#version 130
#extension GL_EXT_gpu_shader4 : enable
// the version and open GL extension
// should be the first line of the shader
/////////////////////////////////////////////////////////////////////////////////
//kali-traps cMod01.fsh   by bergi    
//https://www.shadertoy.com/view/lll3WM
//Licence : Creative Commons Attribution-ShareAlike 4.0
//http://creativecommons.org/licences/by-sa/4.0
// Adapted, trivialy, for use in VGHD player
/////////////////////////////////////////////
uniform float u_Elapsed;    // The elapsed time in seconds
uniform vec2  u_WindowSize; // Window dimensions in pixels

#define iTime u_Elapsed*0.177 //*0.1666
#define iResolution u_WindowSize

//#define mouse AUTO_MOUSE
//#define MOUSE_SPEED vec2(vec2(0.5,0.577777) * 0.25)
//#define MOUSE_POS   vec2((1.0+cos(iTime*MOUSE_SPEED))*u_WindowSize/2.0)
//#define MOUSE_PRESS vec2(0.0,0.0)
//#define AUTO_MOUSE  vec4( MOUSE_POS, MOUSE_PRESS )
//#define RIGID_SCROLL
// alternatively use static mouse definition
#define iMouse vec4(0.0,0.0, 0.0,0.0)
//#define iMouse vec4(512,256,180,120)
uniform sampler2D texture0;
uniform sampler2D texture1;
uniform sampler2D texture2;
uniform sampler2D texture3;
vec4 texture2D_Fract(sampler2D sampler,vec2 P) {return texture2D(sampler,fract(P));}
vec4 texture2D_Fract(sampler2D sampler,vec2 P, float Bias) {return texture2D(sampler,fract(P),Bias);}
#define texture2D texture2D_Fract

/*	kali-traps by bergi in 2015
	
	License Creative Commons Attribution-NonCommercial-ShareAlike 3.0 Unported License. 

	man, just showing ..
	try the other path as well ;)

	here's a quick qt app that helped with the parameter scan
	https://github.com/defgsus/kaliset
	(though it looks quite different with webgl float precision 
     compared to intel floats..)

	It's really difficult to make a good shadertoy selfrunner,
	der Spass liegt im Explorieren dieser Menge.
	
	----- Interact with all the stuff below --------------
*/

// 1 or 2
#define PATH 					1
// 0 or 1 (does not make sense at all times..)
#define PARAM_MORPH				0

// animation time
#if PATH == 1
#	define ti 	(iTime * 1. + 76.)
#else
#	define ti 	(iTime * 2. + 500.)
#endif

// very slight param-set modifier
#define modf (.5 + .5 * sin(ti / 31.))

#if PARAM_MORPH
#	define KALI_PARAM 	vec3(0.99-0.02*modf, 1., .7+.4*sin(ti/71.))
#else
#	define KALI_PARAM 	vec3(0.99-0.02*modf, 1., 1.01+0.02*modf)
#endif
	  
const int  KALI_ITERS = 		29;

// max traces
const int  NUM_ITERS = 			30;
// multisample
const int  NUM_RAYS =			1;
// just for camera
const float PI = 3.14159265;

/** kali set as usual. 
	returns last magnitude step and average */
vec4 average;
float kali(in vec3 p)
{
    average = vec4(0.);
	float mag;
    for (int i=0; i<KALI_ITERS; ++i)
    {
        mag = dot(p, p);
        p = abs(p) / mag;
        average += vec4(p, mag);
        p -= KALI_PARAM;
    }
	average /= 32.;
    return mag;
}

// steps from pos along dir and samples the cloud
// stp is 1e-5 - 1e+?? :)
vec3 ray_color(vec3 pos, vec3 dir, float stp)
{
    vec3 p, col = vec3(0.);
	float t = 0.;
	for (int i=0; i<NUM_ITERS; ++i)
	{
		p = pos + t * dir;
		float d = kali(p);

		// define a surface and get trapped
        // well it's all just numbers and signs really
        // and trial-and-error
        // the 'trap' is: making d small when close to what-looks-good
		d = d*1.4-.3;
            //-d*1.3+1.;
        	//1.4 - abs(1.1 - d);
		
		// always step within a certain range
		t += max(0.0001, min(0.0004+0.01*stp, d )) * (stp + 3. * t);

		// some color
        d = max(-0.5, d-0.5);
		col += average.rgb * (.7+.3*sin(average.rgb*vec3(3,5,7)*2.9)) 
		// by distance to surface
            / (1. + d * d * 400. + t * t / stp * 1000.);
	}
    
    return clamp(col / float(NUM_ITERS) * 7., 0., 1.);
}

// by D. Hoskins https://www.shadertoy.com/view/XlfGWN
float hash(in vec2 uv)
{
	vec3 p  = fract(vec3(uv,ti) / vec3(3.07965, 7.1235, 4.998784));
    p += dot(p.xy, p.yx+19.19);
    return fract(p.x * p.y);
}

//void mainImage( out vec4 fragColor, in vec2 fragCoord )
///////////////////////////////////////////////////////////////////////////////// 
// need to convert this from a void to a function and call it by adding
// a void main(void) { to the end of the shader
// what type of variable will the function return?, it is a color and needs to be a vec4
// change void to vec4 
//void MainImage(out vec4 fragColor, in vec2 fragCoord) 
vec4 mainImage( out vec4 fragColor, in vec2 fragCoord )
{
    // frequency of slowness
    float phasemf = 0.12;
    float phasem = sin(ti*phasemf);
    float phasem2 = sin(ti*phasemf+PI/2.);
    
    // ray stepsize - or focus scale 
    float foc = 0.083 + 0.08*phasem2;

    // camera circle phase
    float rti = 0.05 * (ti + phasem / phasemf * 0.95);
    
    if (iMouse.z > .5) {
        foc = pow(iMouse.y / iResolution.y, 2.)/6.;
    }

	vec2 uv = (fragCoord.xy - iResolution.xy*.5) / iResolution.y * 2.;

#if PATH == 1    
	vec3 pos = (vec3(0.3359+0.007*modf, 0.1139+0.0064*modf, -0.001-0.001*phasem2) 
                + (.0032 + 0.003 * phasem2) * vec3(uv, 0.)
                + (0.113 + 0.005*modf) * vec3(sin(rti),cos(rti),0.) );
    
    vec3 dir = normalize(vec3(uv, 2.5-length(uv)/1.3)).xyz;
#else
    
    foc = foc * 3.4 + 0.01;
    
    vec3 pos = vec3(0.25 + .4*sin(rti), 0.1 * cos(rti), 0.),
    	 posl = vec3(0.25 + .21*pow(sin(rti),3.), 0.02 * cos(rti) + 0.*sin(rti*2.3), -.1);
    
	vec3 look = normalize(posl - pos);
	vec3 up = normalize(cross(vec3(0., 0., -1.), look));
	vec3 right = normalize(cross(look, up));
	//look = normalize(cross(up, right));
	mat3 dirm = mat3(right, up, look);
    // screen / near-plane
    pos += dirm * (0.05 + 0.04 * phasem2) * vec3(uv, 0)
        ;
    vec3 dir = dirm * normalize(vec3(uv, 2.5-length(uv)/1.3)).xyz;
    
#endif    
				
				
    vec3 col = vec3(0.);
    for (float i=0.; i<float(NUM_RAYS); ++i)
    {
        vec3 p = pos + dir * hash(uv*1114.+ti+i*17.) * (0.000002 + 0.001 * foc);
	
    	col += ray_color(p, dir, foc * (1. + 0.03 * i));
	}
    col /= float(NUM_RAYS);
        

	fragColor = vec4(pow(col,vec3(1./1.9)), 1.);	
/////////////////////////////////////////////////////////////////////////////////
//the function needs to return a value. 
//it needs to be a vec4
//we will return the varable fragColor 
// usual place for fragColor = vec4( color, 1.0 ); bring the } down below
return fragColor; 
}

///////////////////////////////////////////////////////////////////////////////// 
void main(void) { // this will be run for every pixel of gl_FragCoord.xy
vec4 vTexCoord = gl_TexCoord[0];
vec4 fragColor = vec4(1.0); // initialize variable fragColor as a vec4 
vec4 cc = mainImage(fragColor, gl_FragCoord.xy); // call function mainImage and assign the return vec4 to cc
gl_FragColor = vec4(cc) * gl_Color; // set the pixel to the value of vec4 cc  and..
//gl_FragColor.a = length(gl_FragColor.rgb);
}

// ..uses the values of any Color: or Opacity:
// clauses (and any Animate clauses applied to these properties) 
// appearing in the Sprite, Quad or other node invoking the shader 
// in the .scn file.

